<?php
/**
 * Background Pattern Style - Ogees.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Ogees
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Ogees extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Ogees', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M11.27,27.67C17.9,33.35,23.62,38.26,23.62,48S17.9,62.66,11.27,68.34c-4,3.39-8.2,7-11.27,11.9H0V96H4.38c0-9.74,5.72-14.64,12.35-20.33,4-3.39,8.2-7,11.27-11.9,3.07,4.87,7.31,8.51,11.27,11.9C45.9,81.35,51.62,86.26,51.62,96H56V80.24c-3.07-4.87-7.31-8.51-11.27-11.91C38.1,62.65,32.38,57.74,32.38,48S38.1,33.35,44.73,27.67c4-3.39,8.2-7,11.27-11.91h0V0H51.62c0,9.74-5.72,14.65-12.35,20.33-4,3.4-8.2,7-11.27,11.91-3.07-4.87-7.31-8.51-11.27-11.9C10.1,14.65,4.38,9.74,4.38,0H0V15.76C3.07,20.64,7.31,24.28,11.27,27.67Z"/>',
				'default-inverted' => '<path d="M0,80.24H0V15.76c3.07,4.88,7.31,8.52,11.27,11.91C17.9,33.35,23.62,38.26,23.62,48S17.9,62.66,11.27,68.34C7.31,71.73,3.07,75.37,0,80.24Zm39.27-4.57c-4-3.39-8.2-7-11.27-11.9-3.07,4.87-7.31,8.51-11.27,11.9C10.1,81.36,4.38,86.26,4.38,96H51.62C51.62,86.26,45.9,81.35,39.27,75.67ZM16.73,20.34c4,3.39,8.2,7,11.27,11.9,3.07-4.87,7.31-8.51,11.27-11.91C45.9,14.65,51.62,9.74,51.62,0H4.38C4.38,9.74,10.1,14.65,16.73,20.34Zm28,7.33C38.1,33.35,32.38,38.26,32.38,48S38.1,62.65,44.73,68.33c4,3.4,8.2,7,11.27,11.91V15.76h0C52.93,20.64,48.69,24.28,44.73,27.67Z"/>',
				'rotated'          => '<path d="M27.67,44.73C33.35,38.1,38.26,32.38,48,32.38S62.65,38.1,68.34,44.73c3.39,4,7,8.2,11.9,11.27H96V51.63c-9.74,0-14.65-5.73-20.33-12.36-3.39-4-7-8.2-11.91-11.27,4.88-3.07,8.51-7.31,11.91-11.27C81.35,10.1,86.26,4.38,96,4.38h0V0H80.24c-4.87,3.07-8.51,7.31-11.91,11.27C62.65,17.9,57.74,23.63,48,23.63S33.35,17.9,27.67,11.27c-3.4-4-7-8.2-11.91-11.27H0V4.38c9.74,0,14.65,5.72,20.33,12.35,3.4,4,7,8.21,11.91,11.27-4.87,3.07-8.51,7.31-11.91,11.27C14.65,45.9,9.74,51.63,0,51.63V56H15.76C20.64,52.93,24.28,48.69,27.67,44.73Z"/>',
				'rotated-inverted' => '<path d="M80.24,56H15.76c4.88-3.07,8.52-7.31,11.91-11.27C33.35,38.1,38.26,32.38,48,32.38S62.65,38.1,68.34,44.73C71.73,48.69,75.37,52.93,80.24,56ZM75.67,16.73c-3.4,4-7,8.2-11.91,11.27,4.88,3.07,8.52,7.31,11.91,11.27C81.35,45.9,86.26,51.62,96,51.63V4.38h0C86.26,4.38,81.35,10.1,75.67,16.73ZM20.33,39.27c3.4-4,7-8.2,11.91-11.27-4.87-3.06-8.51-7.31-11.91-11.27C14.65,10.1,9.74,4.38,0,4.38V51.63C9.74,51.63,14.65,45.9,20.33,39.27Zm7.34-28C33.35,17.9,38.26,23.63,48,23.63S62.65,17.9,68.33,11.27c3.4-4,7-8.2,11.91-11.27H15.76C20.63,3.07,24.27,7.31,27.67,11.27Z"/>',
				'thumbnail'        => '<path d="M77.7,5.76A11,11,0,0,0,80,3.28h0V0h-.89c0,2-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48A11.2,11.2,0,0,0,72,4.24C70.63,3.05,69.46,2,69.46,0H67.68c0,2-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48,11,11,0,0,0-2.3-2.48C59.2,3.05,58,2,58,0H56.25c0,2-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48,11,11,0,0,0-2.3-2.48C47.78,3.05,46.61,2,46.61,0H44.82c0,2-1.17,3.05-2.52,4.24A11,11,0,0,0,40,6.72a11,11,0,0,0-2.3-2.48C36.35,3.05,35.18,2,35.18,0H33.39c0,2-1.17,3.05-2.52,4.24a11,11,0,0,0-2.3,2.48,10.75,10.75,0,0,0-2.3-2.48C24.92,3.05,23.75,2,23.75,0H22c0,2-1.16,3.05-2.52,4.24a11,11,0,0,0-2.3,2.48,10.75,10.75,0,0,0-2.3-2.48C13.49,3.05,12.32,2,12.32,0H10.54c0,2-1.17,3.05-2.53,4.24a11.2,11.2,0,0,0-2.3,2.48,10.75,10.75,0,0,0-2.3-2.48C2.06,3.05.89,2,.89,0H0V3.28A11,11,0,0,0,2.3,5.76C3.65,7,4.82,8,4.82,10S3.65,13.05,2.3,14.24A11,11,0,0,0,0,16.72H0v6.56a11,11,0,0,0,2.3,2.48C3.65,27,4.82,28,4.82,30s-1.17,3-2.52,4.24A11,11,0,0,0,0,36.72H0v6.56a11,11,0,0,0,2.3,2.48C3.65,47,4.82,48,4.82,50s-1.17,3-2.52,4.24A11,11,0,0,0,0,56.72H0V60H.89c0-2,1.17-3,2.52-4.23a11,11,0,0,0,2.3-2.49A11.2,11.2,0,0,0,8,55.76C9.37,57,10.54,58,10.54,60h1.78c0-2,1.17-3,2.52-4.23a11,11,0,0,0,2.3-2.49,11,11,0,0,0,2.3,2.48C20.8,57,22,58,22,60h1.79c0-2,1.17-3,2.52-4.23a11,11,0,0,0,2.3-2.49,11,11,0,0,0,2.3,2.48C32.22,57,33.39,58,33.39,60h1.79c0-2,1.17-3,2.52-4.23A11.24,11.24,0,0,0,40,53.28a11,11,0,0,0,2.3,2.48C43.65,57,44.82,58,44.82,60h1.79c0-2,1.17-3,2.52-4.23a11.24,11.24,0,0,0,2.3-2.49,10.75,10.75,0,0,0,2.3,2.48C55.08,57,56.25,58,56.25,60H58c0-2,1.16-3,2.52-4.23a11.24,11.24,0,0,0,2.3-2.49,10.75,10.75,0,0,0,2.3,2.48C66.51,57,67.68,58,67.68,60h1.78c0-2,1.17-3,2.53-4.23a11.48,11.48,0,0,0,2.3-2.49,10.75,10.75,0,0,0,2.3,2.48C77.94,57,79.11,58,79.11,60H80V56.72a11,11,0,0,0-2.3-2.48C76.35,53.05,75.18,52,75.18,50s1.17-3,2.52-4.24A11,11,0,0,0,80,43.28h0V36.72a11,11,0,0,0-2.3-2.48C76.35,33.05,75.18,32,75.18,30S76.35,27,77.7,25.76A11,11,0,0,0,80,23.28h0V16.72a11,11,0,0,0-2.3-2.48C76.35,13.05,75.18,12,75.18,10S76.35,7,77.7,5.76Zm-11.43,0a10.75,10.75,0,0,0,2.3-2.48h0a11,11,0,0,0,2.3,2.48C72.22,7,73.39,8,73.39,10s-1.17,3.05-2.52,4.24a11,11,0,0,0-2.3,2.48h0a10.75,10.75,0,0,0-2.3-2.48C64.92,13.05,63.75,12,63.75,10S64.92,7,66.27,5.76Zm2.3,31a10.75,10.75,0,0,0-2.3-2.48C64.92,33.05,63.75,32,63.75,30s1.17-3.05,2.52-4.24a10.75,10.75,0,0,0,2.3-2.48h0a11,11,0,0,0,2.3,2.48C72.22,27,73.39,28,73.39,30s-1.17,3-2.52,4.24a11,11,0,0,0-2.3,2.48ZM62.86,13.28a10.75,10.75,0,0,0,2.3,2.48C66.51,17,67.68,18,67.68,20s-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48,11,11,0,0,0-2.3-2.48C59.2,23.05,58,22,58,20S59.2,17,60.56,15.77A11.24,11.24,0,0,0,62.86,13.28ZM57.14,36.72a10.75,10.75,0,0,0-2.3-2.48C53.49,33.05,52.32,32,52.32,30s1.17-3.05,2.52-4.24a10.75,10.75,0,0,0,2.3-2.48h0a11,11,0,0,0,2.3,2.48C60.8,27,62,28,62,30s-1.16,3-2.52,4.24a11,11,0,0,0-2.3,2.48Zm-2.3-31a10.75,10.75,0,0,0,2.3-2.48h0a11,11,0,0,0,2.3,2.48C60.8,7,62,8,62,10s-1.16,3.05-2.52,4.24a11,11,0,0,0-2.3,2.48h0a10.75,10.75,0,0,0-2.3-2.48C53.49,13.05,52.32,12,52.32,10S53.49,7,54.84,5.76Zm-3.41,7.52a10.75,10.75,0,0,0,2.3,2.48C55.08,17,56.25,18,56.25,20s-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48,11,11,0,0,0-2.3-2.48C47.78,23.05,46.61,22,46.61,20h0c0-2,1.17-3.05,2.52-4.23A11.24,11.24,0,0,0,51.43,13.28ZM45.71,36.72a10.75,10.75,0,0,0-2.3-2.48C42.06,33.05,40.89,32,40.89,30s1.17-3.05,2.52-4.24a10.75,10.75,0,0,0,2.3-2.48h0A11.2,11.2,0,0,0,48,25.76C49.37,27,50.54,28,50.54,30s-1.17,3-2.53,4.24a11.2,11.2,0,0,0-2.3,2.48Zm-2.3-31a10.75,10.75,0,0,0,2.3-2.48h0A11.2,11.2,0,0,0,48,5.76C49.37,7,50.54,8,50.54,10S49.37,13.05,48,14.24a11.2,11.2,0,0,0-2.3,2.48h0a10.75,10.75,0,0,0-2.3-2.48C42.06,13.05,40.89,12,40.89,10S42.06,7,43.41,5.76ZM40,13.28a11,11,0,0,0,2.3,2.48C43.65,17,44.82,18,44.82,20s-1.17,3.05-2.52,4.24A11,11,0,0,0,40,26.72a11,11,0,0,0-2.3-2.48C36.35,23.05,35.18,22,35.18,20h0c0-2,1.17-3.05,2.52-4.23A11.24,11.24,0,0,0,40,13.28ZM34.29,36.72A11.2,11.2,0,0,0,32,34.24C30.63,33.05,29.46,32,29.46,30S30.63,27,32,25.76a11.2,11.2,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C37.94,27,39.11,28,39.11,30s-1.17,3-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48ZM32,5.76a11.2,11.2,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C37.94,7,39.11,8,39.11,10s-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48h0A11.2,11.2,0,0,0,32,14.24C30.63,13.05,29.46,12,29.46,10S30.63,7,32,5.76Zm-3.42,7.52a11,11,0,0,0,2.3,2.48C32.22,17,33.39,18,33.39,20s-1.17,3.05-2.52,4.24a11,11,0,0,0-2.3,2.48,10.75,10.75,0,0,0-2.3-2.48C24.92,23.05,23.75,22,23.75,20s1.17-3.05,2.52-4.23A11,11,0,0,0,28.57,13.28ZM22.86,36.72a11,11,0,0,0-2.3-2.48C19.2,33.05,18,32,18,30S19.2,27,20.56,25.76a11,11,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C26.51,27,27.68,28,27.68,30s-1.17,3-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48Zm-2.3-31a11,11,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C26.51,7,27.68,8,27.68,10s-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48h0a11,11,0,0,0-2.3-2.48C19.2,13.05,18,12,18,10S19.2,7,20.56,5.76Zm-3.42,7.52a11,11,0,0,0,2.3,2.48C20.8,17,22,18,22,20s-1.16,3.05-2.52,4.24a11,11,0,0,0-2.3,2.48,10.75,10.75,0,0,0-2.3-2.48C13.49,23.05,12.32,22,12.32,20s1.17-3.05,2.52-4.23A11,11,0,0,0,17.14,13.28ZM11.43,36.72a11,11,0,0,0-2.3-2.48C7.78,33.05,6.61,32,6.61,30S7.78,27,9.13,25.76a11,11,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C15.08,27,16.25,28,16.25,30s-1.17,3-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48Zm-2.3-31a11,11,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C15.08,7,16.25,8,16.25,10s-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48h0a11,11,0,0,0-2.3-2.48C7.78,13.05,6.61,12,6.61,10S7.78,7,9.13,5.76ZM3.41,24.24C2.06,23.05.89,22,.89,20h0c0-2,1.17-3.05,2.52-4.23a11,11,0,0,0,2.3-2.49A11.2,11.2,0,0,0,8,15.76C9.37,17,10.54,18,10.54,20S9.37,23.05,8,24.24a11.2,11.2,0,0,0-2.3,2.48A10.75,10.75,0,0,0,3.41,24.24Zm2.3,22.48a10.75,10.75,0,0,0-2.3-2.48C2.06,43.05.89,42,.89,40h0c0-2,1.17-3,2.52-4.23a11,11,0,0,0,2.3-2.49A11.2,11.2,0,0,0,8,35.76C9.37,37,10.54,38,10.54,40s-1.17,3-2.53,4.24A11.2,11.2,0,0,0,5.71,46.72Zm8,7.52a10.75,10.75,0,0,0-2.3,2.48h0a11,11,0,0,0-2.3-2.48C7.78,53.05,6.61,52,6.61,50s1.17-3,2.52-4.24a11,11,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C15.08,47,16.25,48,16.25,50S15.08,53.05,13.73,54.24Zm3.41-7.52a10.75,10.75,0,0,0-2.3-2.48C13.49,43.05,12.32,42,12.32,40s1.17-3,2.52-4.23a11,11,0,0,0,2.3-2.49,11,11,0,0,0,2.3,2.48C20.8,37,22,38,22,40s-1.16,3-2.52,4.24A11,11,0,0,0,17.14,46.72Zm8,7.52a10.75,10.75,0,0,0-2.3,2.48h0a11,11,0,0,0-2.3-2.48C19.2,53.05,18,52,18,50s1.16-3,2.52-4.24a11,11,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C26.51,47,27.68,48,27.68,50S26.51,53.05,25.16,54.24Zm3.41-7.52a10.75,10.75,0,0,0-2.3-2.48C24.92,43.05,23.75,42,23.75,40s1.17-3,2.52-4.23a11,11,0,0,0,2.3-2.49,11,11,0,0,0,2.3,2.48C32.22,37,33.39,38,33.39,40s-1.17,3-2.52,4.24A11,11,0,0,0,28.57,46.72Zm8,7.52a10.75,10.75,0,0,0-2.3,2.48h0A11.2,11.2,0,0,0,32,54.24C30.63,53.05,29.46,52,29.46,50s1.17-3,2.53-4.24a11.2,11.2,0,0,0,2.3-2.48h0a10.75,10.75,0,0,0,2.3,2.48C37.94,47,39.11,48,39.11,50S37.94,53.05,36.59,54.24ZM40,46.72a11,11,0,0,0-2.3-2.48C36.35,43.05,35.18,42,35.18,40h0c0-2,1.17-3,2.52-4.23A11.24,11.24,0,0,0,40,33.28a11,11,0,0,0,2.3,2.48C43.65,37,44.82,38,44.82,40s-1.17,3-2.52,4.24A11,11,0,0,0,40,46.72Zm8,7.52a11.2,11.2,0,0,0-2.3,2.48h0a10.75,10.75,0,0,0-2.3-2.48C42.06,53.05,40.89,52,40.89,50s1.17-3,2.52-4.24a10.75,10.75,0,0,0,2.3-2.48h0A11.2,11.2,0,0,0,48,45.76C49.37,47,50.54,48,50.54,50S49.37,53.05,48,54.24Zm3.42-7.52a11,11,0,0,0-2.3-2.48C47.78,43.05,46.61,42,46.61,40h0c0-2,1.17-3,2.52-4.23a11.24,11.24,0,0,0,2.3-2.49,10.75,10.75,0,0,0,2.3,2.48C55.08,37,56.25,38,56.25,40s-1.17,3-2.52,4.24A10.75,10.75,0,0,0,51.43,46.72Zm8,7.52a11,11,0,0,0-2.3,2.48h0a10.75,10.75,0,0,0-2.3-2.48C53.49,53.05,52.32,52,52.32,50s1.17-3,2.52-4.24a10.75,10.75,0,0,0,2.3-2.48h0a11,11,0,0,0,2.3,2.48C60.8,47,62,48,62,50S60.8,53.05,59.44,54.24Zm3.42-7.52a11,11,0,0,0-2.3-2.48C59.2,43.05,58,42,58,40s1.16-3,2.52-4.23a11.24,11.24,0,0,0,2.3-2.49,10.75,10.75,0,0,0,2.3,2.48C66.51,37,67.68,38,67.68,40s-1.17,3-2.52,4.24A10.75,10.75,0,0,0,62.86,46.72Zm8,7.52a11,11,0,0,0-2.3,2.48h0a10.75,10.75,0,0,0-2.3-2.48C64.92,53.05,63.75,52,63.75,50s1.17-3,2.52-4.24a10.75,10.75,0,0,0,2.3-2.48h0a11,11,0,0,0,2.3,2.48C72.22,47,73.39,48,73.39,50S72.22,53.05,70.87,54.24Zm5.72-18.48C77.94,37,79.11,38,79.11,40s-1.17,3-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48A11.2,11.2,0,0,0,72,44.24C70.63,43.05,69.46,42,69.46,40s1.17-3,2.53-4.23a11.48,11.48,0,0,0,2.3-2.49A10.75,10.75,0,0,0,76.59,35.76Zm0-20C77.94,17,79.11,18,79.11,20s-1.17,3.05-2.52,4.24a10.75,10.75,0,0,0-2.3,2.48A11.2,11.2,0,0,0,72,24.24C70.63,23.05,69.46,22,69.46,20S70.63,17,72,15.77a11.48,11.48,0,0,0,2.3-2.49A10.75,10.75,0,0,0,76.59,15.76Z"/>',
			),
			'width'      => '56px',
			'height'     => '96px',
		);
	}
}

return new ET_Builder_Pattern_Ogees();
